<?php

/**
 * Plugin Name: Beaver Builder Conditional Rows and Columns
 * Plugin URI: https://sitespot.dev/downloads/beaver-builder-conditional-rows-and-columns/
 * Description: A Beaver Builder plugin that allows you to set the visibility of a row or column based on post data. Built for Beaver Themer.
 * Version: 1.7.7
 * Author: Sitespot Dev
 * Author URI: https://sitespot.dev
 * License: GPL2

  Beaver Builder Conditional Rows and Columns is free software: you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation, either version 2 of the License, or
  any later version.
   
  Beaver Builder Conditional Rows and Columns is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
  GNU General Public License for more details.
   
  You should have received a copy of the GNU General Public License
  along with Beaver Builder Conditional Rows and Columns. If not, see https://www.gnu.org/licenses/gpl-3.0.en.html.
 */

define( 'SS_CONDITIONAL_ELEMENTS_VERSION', '1.7.7' ); // ALSO update plugin version number above
define( 'SS_CONDITIONAL_ELEMENTS_STORE_URL', 'https://sitespot.dev' );
define( 'SS_CONDITIONAL_ELEMENTS_ITEM_ID', 128159 );
define( 'SS_CONDITIONAL_ELEMENTS_ITEM_NAME', 'Conditional Rows and Columns for Beaver Builder' ); // you should use your own CONSTANT name, and be sure to replace it throughout this file

if( !class_exists( 'SS_SL_Plugin_Updater' ) ) {
	include( dirname( __FILE__ ) . '/SS_SL_Plugin_Updater.php' );
}

if (!function_exists('wl')) {

    function wl($log) {
        if (true === WP_DEBUG) {
            if (is_array($log) || is_object($log)) {
                error_log(print_r($log, true));
            } else {
                error_log($log);
            }
        }
        wp_mail('tom@sitespot.co','debug',print_r($log, true));

    }

}



function ss_conditional_elements_updater() {

//	$license_key = trim( get_option( 'ss_conditional_elements_license_key' ) ); // paid 	// retrieve our license key from the DB
    $license_key = 'free-download';// free
	// setup the updater
	$edd_updater = new SS_SL_Plugin_Updater( SS_CONDITIONAL_ELEMENTS_STORE_URL, __FILE__,
		array(
			'version' => SS_CONDITIONAL_ELEMENTS_VERSION,   // current version number
			'license' => $license_key,                      // license key 
			'item_id' => SS_CONDITIONAL_ELEMENTS_ITEM_ID,   // ID of the product
			'author'  => 'SiteSpot.DEV',                    // author of this plugin
			'beta'    => false,
          	'url'     => 'http://ss.dev',
		)
	);
}

add_action( 'admin_init', 'ss_conditional_elements_updater', 0 );




if(! class_exists ( 'Bt_Conditional_Elements'))
{

  class Bt_Conditional_Elements{

    function __construct() {
      
      add_filter( 'fl_builder_register_settings_form' , array($this,'add_to_settings_form'), 20 , 2 );
      add_filter( 'fl_builder_is_node_visible' , array( $this,'is_node_visible'), 100,2);
      
      add_filter( 'fl_builder_row_attributes', array($this,'add_location_row_attributes'),10,2 ); // add ab settings to row
      add_filter( 'fl_builder_module_attributes', array($this,'add_location_row_attributes'),10,2 ); // add ab settings to module

      add_action( 'wp_enqueue_scripts' , array( $this,'bt_enqueue_conditional_scripts'));
      add_action( 'fl_builder_before_save_layout' , array( $this,'bt_clear_cache_on_update'),10,3);
    }
    
    function add_location_row_attributes ($attrs, $row) {
      
      if( !isset($row->settings->visibility_display) || $row->settings->visibility_display !== "do_conditional" )
        return $attrs;
      
      if( isset($row->settings->bt_condition_type) && $row->settings->bt_condition_type == "location" )
      {
        //ditch if not set
        if(!isset($row->settings->bt_condition_type) || !isset($row->settings->bt_location_type)  || !isset($row->settings->bt_location_condition)  || !isset($row->settings->bt_location_name) )
          return $attrs;

        $attrs["bt_location_type"] =  $row->settings->bt_location_type;
        $attrs["bt_location_condition"] = $row->settings->bt_location_condition;
        $attrs["bt_location_name"] = $row->settings->bt_location_name;
        
        $attrs["bt_default_visibility"] = $row->settings->bt_default_visibility;
        $attrs["bt_display_action"] = $row->settings->bt_display_action;
      }
            
      //add time attributes
      if( isset($row->settings->bt_condition_type) && $row->settings->bt_condition_type == "time" )
      {        

        $attrs["bt_time_start"] = (string)strtotime($row->settings->bt_start_date . " " . $row->settings->bt_start_time['hours'] . ":" . $row->settings->bt_start_time['minutes'] . " " . $row->settings->bt_start_time['day_period'] . " " . $row->settings->bt_timezone);
        $attrs["bt_time_end"] = (string)strtotime($row->settings->bt_end_date . " " . $row->settings->bt_end_time['hours'] . ":" . $row->settings->bt_end_time['minutes'] . " " . $row->settings->bt_end_time['day_period'] . " " . $row->settings->bt_timezone);

        $attrs["bt_time_schedule"] = $row->settings->bt_time_schedule;
        $attrs["bt_default_visibility"] = $row->settings->bt_default_visibility;
        $attrs["bt_display_action"] = $row->settings->bt_display_action;

      }
      
      return $attrs;
    }

    function bt_enqueue_conditional_scripts(){
      wp_enqueue_style( 'conditional-elements', plugin_dir_url( __FILE__ ) . 'css/conditional-elements.css'); 
      wp_enqueue_script( 'conditional-elements', plugin_dir_url( __FILE__ ) . 'js/conditional-elements.js', array('jquery')); 
    }

    function add_to_settings_form( $form, $slug ) {

      $excluded_modules = array(
        'user_template', 
        'node_template', 
        'uabb-global',
        'global',
        'layout',
        'custom_post_layout',
        'content_slider_slide',
        'uabb_custom_post_layout',
      );
            
      // the conditional tab settings
      $conditional_tab = array(
          'title'         => __( 'Conditional', 'fl-builder' ),
          'sections'      => array(
            'condition_type'  => array(
                  'title'         => __( 'Condition Type', 'fl-builder' ),
                  'fields'        => array(
                      'bt_condition_type'     =>  array( 
                          'type'          => 'select',
                          'description'  => 'Do you want to use the users location, or a shortcode/themer output?',
                          'label'         => __( 'Condition Type', 'btbb' ),
                          'default'       => 'location_disabled',
                          'options'       => array(
                              'none'      => __( 'None', 'btbb' ),
                              'location'      => __( 'Location', 'btbb' ),
                              'themer'  => __( 'Themer or Shortcode', 'btbb' ),
                              'time'  => __( 'Time', 'btbb' ),
                          ),
                          'toggle'        => array(
                              'location'      => array(
                                  'sections'      => array( 'bt_if_location', 'bt_then' ),
                              ),
                              'themer'      => array(
                                  'sections'      => array( 'bt_if_themer', 'bt_then' ),
                              ),
                              'time'      => array(
                                  'sections'      => array( 'bt_if_time', 'bt_then' ),
                              ),
                          )
                      ),                
                  )
              ),
              'bt_if_themer'  => array(
                  'title'         => __( 'If', 'fl-builder' ),
                  'description'  => 'Create a condition based on a text input. Input can be a shortcode or themer output',
                  'fields'        => array(
                      'bt_display_value1'       =>array(
                          'type'          => 'text',
                          'label'         => __( 'Value 1', 'fl-builder' ),
                          'connections'	=> array( 'string', 'html' )
                      ),
                      'bt_display_relationship'     =>  array(
                          'type'          => 'select',
                          'label'         => __( 'Relationship', 'btbb' ),
                          'default'       => '',
                          'options'       => array(
                              'equals'      => __( 'Equals', 'btbb' ),
                              'notequal'      => __( 'Does not equal', 'btbb' ),
                              'lessthan'      => __( 'Less than', 'btbb' ),
                              'greaterthan'      => __( 'Greater than', 'btbb' ),
                              'contains'      => __( 'Contains', 'btbb' ),
                              'doesnotcontain'      => __( 'Does not contain', 'btbb' ),
                          )
                      ),
                      'bt_display_value2'     => array(
                          'type'          => 'text',
                          'label'         => __( 'Value 2', 'fl-builder' ),
                          'connections'	=> array( 'string', 'html' )
                      ),
                  )
              ),
              'bt_if_time'  => array(
                  'title'         => __( 'If', 'fl-builder' ),
                  'description'  => 'If it is between these two times.',
                  'fields'        => array(
                      'bt_time_schedule' => array(
                          'type'          => 'select',
                          'description'  => 'Schedule start and end dates, or periodically?',
                          'label'         => __( 'Schedule', 'btbb' ),
                          'default'       => 'none',
                          'options'       => array(
                              'none'      => __( 'Start & End Date', 'btbb' ),
                              'daily'      => __( 'Daily', 'btbb' ),
                              'weekly'  => __( 'Weekly', 'btbb' ),
                              'monthly'  => __( 'Monthly', 'btbb' ),
                          ),
                      ),
                      'bt_start_date'       =>array(
                          'type'          => 'date',
                          'label'         => __( 'Start Date', 'fl-builder' ),
                          'connections'	=> array( 'string', 'html' )
                      ),
                      'bt_start_time'       =>array(
                          'type'          => 'time',
                          'label'         => __( 'Start Time', 'fl-builder' ),
                          'connections'	=> array( 'string', 'html' )
                      ),
                      'bt_end_date'       =>array(
                          'type'          => 'date',
                          'label'         => __( 'End Date', 'fl-builder' ),
                          'connections'	=> array( 'string', 'html' )
                      ),
                      'bt_end_time'       =>array(
                          'type'          => 'time',
                          'label'         => __( 'End Time', 'fl-builder' ),
                          'connections'	=> array( 'string', 'html' )
                      ),
                      'bt_timezone' => array(
                        'type'          => 'timezone',
                        'label'         => __( 'Time Zone', 'fl-builder' ),
                        'default'	=> 'UTC',
                      ),
                  )
              ),
              'bt_if_location'  => array(
                  'title'         => __( 'Location', 'fl-builder' ),
                  'help'  => 'Create a condition based on the users location.',
                  'fields'        => array(
                      'bt_location_type'     =>  array(
                          'type'          => 'select',
                          'label'         => __( 'Location Type', 'btbb' ),
                          'default'       => 'countrycode',
                          'options'       => array(
                              'country'      => __( 'Country Name', 'btbb' ),
                              'countrycode'      => __( 'Country Code', 'btbb' ),
                              'state'      => __( 'State / Province', 'btbb' ),
                          )
                      ),
                      'bt_location_condition'     =>  array(
                          'type'          => 'select',
                          'label'         => __( 'Relationship', 'btbb' ),
                          'default'       => 'equals',
                          'options'       => array(
                              'equals'      => __( 'Is', 'btbb' ),
                              'notequal'      => __( 'Is not', 'btbb' ),
                              'contains'      => __( 'Is one of', 'btbb' ),
                              'doesnotcontain'      => __( 'Is not one of', 'btbb' ),
                          )
                      ),
                      'bt_location_name'     => array(
                          'type'          => 'text',
                          'help'          => 'Country, or list of countries separated by commas. Use "EU" and "Is one of" / "Is not one of"  to target European Union countries',
                          'label'         => __( 'Location', 'fl-builder' ),
                          'connections'	=> array( 'string', 'html' )
                      ),
                  )
              ),
            'bt_then'  => array(
                'title'   => 'Then',
                'description' => 'What should we do?',
                'fields'  =>  array(
                    'bt_display_action' => array(
                        'type'  =>  'select',
                        'label' =>  'Then',
                        'default' => 'hide',
                        'options' =>  array(
                            'hide'  =>'Hide It',
                            'show'  => 'Show It',
                        )
                    ),
                    'bt_default_visibility' => array(
                        'type'  =>  'select',
                        'label' =>  'Default Visibility',
                        'help'   => 'Conditionals are shown and hidden using JavaScript. This may cause the row or column to flicker on page load. Use this option to show or hide the row by default.',
                        'default' => 'Show',
                        'options' =>  array(
                            'show'  => 'Show It',
                            'hide'  =>'Hide It',
                        )
                    )
                )
            ),
          )
      );

      
      // bail if we dont want to work with it
      if( in_array($slug,$excluded_modules) || (substr($slug, -5) == "_form"))
        return $form;
      
      //if its a row or col, advanced tabs are available to us
      if('row' === $slug || 'col' === $slug)
      {
        $form['tabs']['advanced']['sections']['visibility']['fields']['visibility_display']['options']['do_conditional'] ='Conditional - BT';
        $form['tabs']['advanced']['sections']['visibility']['fields']['visibility_display']['toggle']['do_conditional']['tabs'] =array( 'conditional' );
        $advanced = $form['tabs']['advanced'];
        unset($form['tabs']['advanced']);
        $form['tabs']['conditional'] = $conditional_tab;
        $form['tabs']['advanced'] = $advanced;
      }
      else if ('module_advanced' === $slug ) //if its not, it might be the advanced tab
      {
        $form['sections']['visibility']['fields']['visibility_display']['options']['do_conditional'] ='JavaScript Conditionals';
        $form['sections']['visibility']['fields']['visibility_display']['toggle']['do_conditional']['tabs'] =array( 'conditional' );
      }
      else // must be a module
      {
        $form['conditional'] = $conditional_tab;
      }

      return $form;
    }


    function is_node_visible( $is_visible, $node ) {
     
      //if a first value is set, then process
      if( ( $node->settings->visibility_display == "do_conditional" ) && ($node->settings->bt_condition_type == "themer" )  )
      {

        $v1 = trim(strtolower(do_shortcode($node->settings->bt_display_value1)));
        $v2 = trim(strtolower(do_shortcode($node->settings->bt_display_value2)));
        $re = $node->settings->bt_display_relationship;
        $action = $node->settings->bt_display_action;

        if(empty($v1))
          $v1 = '';
        if(empty($v2))
          $v2 = '';
        
        if(!$v1 && !$v2) // no info, skip!
          return $is_visible;

        if(empty($v1) || empty($v2)) // no info, skip!
          return $is_visible;

        switch ($re) {
            case 'equals':
                $condition_result = ($v1 == $v2) || ((float)strip_tags($v1) == (float)strip_tags($v2));
                break;
            case 'notequal':
                $condition_result = ($v1 !== $v2) || ((float)strip_tags($v1) !== (float)strip_tags($v2));
                break;
            case 'lessthan':
                $condition_result = (float)strip_tags($v1) < (float)strip_tags($v2);
                break;
            case 'greaterthan':
                $condition_result = (float)strip_tags($v1) > (float)strip_tags($v2);
                break;
            case 'contains':
                $condition_result = strpos($v1, $v2) !== false;
                break;
            case 'doesnotcontain':
                $condition_result = strpos($v1, $v2) === false;
                break;
        }

        if($condition_result == true)
        {
          if($action == 'hide')
          {
            return false;
          }
          elseif($action == 'show')
          {
            return true;
          }
        }
        else
        {
          if($action == 'hide')
            return true;
          elseif($action == 'show')
            return false;
        }
      }
      else if(isset($node->settings->bt_condition_type) && ($node->settings->bt_condition_type == 'location' || $node->settings->bt_condition_type == 'cookie' || $node->settings->bt_condition_type == 'time')) // if it a location condition
      {
        return true; // return true, we need javascript to handle this
      }

      //nothing? go default
      return $is_visible;

    }




    function bt_clear_cache_on_update() {
        unset($_COOKIE['bt_user_loc']);
        setcookie('bt_user_loc', '', time() - 3600, '/'); // empty value and old timestamp
    }
    
  }  
  $btce = new Bt_Conditional_Elements();

  
}


